package com.ejie.ab04b.service;

import com.ejie.ab04b.dao.ObraDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.Obra;

/**
 * ObraServiceImpl generated by UDA, 22-feb-2017 8:54:47.
 * 
 * @author UDA
 */

@Service(value = "ab0482s00Service")
public class ObraServiceImpl implements ObraService {

	@Autowired
	private ObraDao ab0482s00Dao;

	/**
	 * Inserts a single row in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  Obra
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @return the obra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Obra add(Obra ab0482s00) {
		return this.ab0482s00Dao.add(ab0482s00);
	}

	/**
	 * Updates a single row in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  Obra
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @return the obra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Obra update(Obra ab0482s00) {
		return this.ab0482s00Dao.update(ab0482s00);
	}

	/**
	 * Finds a single row in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  Obra
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @return the obra
	 */
	public Obra find(Obra ab0482s00) {
		return (Obra) this.ab0482s00Dao.find(ab0482s00);
	}

	/**
	 * Deletes a single row in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Obra ab0482s00) {
		this.ab0482s00Dao.remove(ab0482s00);
	}

	/**
	 * Finds a list of rows in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Obra>
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Obra> findAll(Obra ab0482s00, JQGridRequestDto jqGridRequestDto) {
		return (List<Obra>) this.ab0482s00Dao.findAll(ab0482s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Obra table using like.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Obra>
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<Obra> findAllLike(Obra ab0482s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Obra>) this.ab0482s00Dao.findAllLike(ab0482s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Obra table.
	 * 
	 *  filterObra
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterObra the filter obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(Obra filterObra,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab0482s00Dao.removeMultiple(filterObra, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Obra table.
	 * 
	 *  filterObra
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Obra>
	 *
	 * @param filterObra the filter obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Obra> filter(Obra filterObra,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Obra> listaObra = this.ab0482s00Dao.findAllLike(filterObra,
				jqGridRequestDto, false);
		Long recordNum = this.ab0482s00Dao.findAllLikeCount(
				filterObra != null ? filterObra : new Obra(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Obra>> reorderSelection = this.ab0482s00Dao
					.reorderSelection(filterObra, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<Obra>(jqGridRequestDto, recordNum,
					listaObra, reorderSelection);
		}
		return new JQGridResponseDto<Obra>(jqGridRequestDto, recordNum,
				listaObra);
	}

	/**
	 * Searches rows in the Obra table.
	 * 
	 *  filterObra
	 *            Obra
	 *  searchObra
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Obra>>
	 *
	 * @param filterObra the filter obra
	 * @param searchObra the search obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<Obra>> search(Obra filterObra, Obra searchObra,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0482s00Dao.search(filterObra, searchObra,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Obra table.
	 * 
	 *  filterObra
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterObra the filter obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(Obra filterObra,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0482s00Dao.reorderSelection(filterObra, jqGridRequestDto,
				startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Obra table.
	 * 
	 *  filterObra
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<JerarquiaDto<Obra>>
	 *
	 * @param filterObra the filter obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<Obra>> jerarquia(Obra filterObra,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<JerarquiaDto<Obra>> listaObra = this.ab0482s00Dao
				.findAllLikeJerarquia(filterObra, jqGridRequestDto);
		Long recordNum = this.ab0482s00Dao.findAllLikeCountJerarquia(
				filterObra, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Obra>>(jqGridRequestDto,
				recordNum, listaObra);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Obra table.
	 * 
	 *  filterObra
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<JerarquiaDto<Obra>>
	 *
	 * @param filterObra the filter obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<Obra>> jerarquiaChildren(
			Obra filterObra, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Obra>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Obra>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.ab0482s00Dao.findAllChild(filterObra, jqGridRequestDto));
		return jqGridResponseDto;
	}

}
